<?php

if (!defined('ABSPATH')) {
    exit;
}

class Ultimate_AI_Integration_Controller
{
    public function __construct()
    {
        add_action('wp_ajax_ultimate_ai_save_elevenlabs_api_key', [$this, 'ultimate_ai_save_elevenlabs_api_key']);
        add_action('wp_ajax_ultimate_ai_get__elevenlabs_api_key', [$this, 'ultimate_ai_get__elevenlabs_api_key']);
    }

    public function ultimate_ai_get__elevenlabs_api_key()
    {
        $menu = get_option('ultimate_ai_elevenlabs_api_key', []);

        wp_send_json($menu, 200);
    }

    public function ultimate_ai_save_elevenlabs_api_key()
    {
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Permission denied', 403);
        }
        $elevenlabs_key = isset($_POST['elevenlabs_key']) ? $_POST['elevenlabs_key'] : '';

        if (!$this->option_exists('ultimate_ai_elevenlabs_api_key')) {
            add_option('ultimate_ai_elevenlabs_api_key', $elevenlabs_key);
        } else {
            update_option('ultimate_ai_elevenlabs_api_key', $elevenlabs_key);
        }
        $elevenlabs_key = get_option('ultimate_ai_elevenlabs_api_key', '');

        wp_send_json($elevenlabs_key, 200);
    }

    public function option_exists($name, $site_wide = false)
    {
        global $wpdb;

        return $wpdb->query('SELECT * FROM '.($site_wide ? $wpdb->base_prefix : $wpdb->prefix)."options WHERE option_name ='$name' LIMIT 1");
    }
}

new Ultimate_AI_Integration_Controller();
